<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use \App\Models\PrefilledQuestions;
use \App\Models\ChatService;
use \App\Models\CalenderService;
use \App\Models\EnabledService;
use \App\Models\DiscussionService;
use App\Models\PaymentDetails;
use App\Models\ServiceSchedule;
use stdClass;

class ServiceController extends Controller
{

    public function __construct(){
        // define('ENABLE',1);
        // define('DISABLE',0);
        // define('SCHEDULE_CALENDAR',1); //calendar type
        // define('OPEN_CALENDAR',2); //calendar type
    }
    public function updateSettings(Request $request)
    {
        $user = auth()->user();

        $calendarService = [];
        if ($request->calendar_service) {



            if (isset($request->calendar_service['enable']) && $request->calendar_service['enable'] == 1) {
                $this->enableServices(['service' => 1]);
            } else {
                $this->disableServices(['service' => 1]);
            }


            $csc = new CalenderServiceController($request);
            if ($request->calendar_service['calendar_type'] == 1) {
                $calendarService = $csc->store($request);
            } else if ($request->calendar_service['calendar_type'] == 2) {
                $calendarService = $csc->store($request);
            }
        }

        $prefilledQuestions = [];
        if ($request->prefilled_questions) {
            $prefilledQuestions = $this->addPrefilledQuestions($request);
        }

        $chatService = [];
        if ($request->chat) {
            $chatService = $this->updateChatService($request);
        }

        $appointment = [];
        if ($request->appointment) {
            $appointment = $this->enableAppointment($request);
        }

        $discussion = [];
        if ($request->discussion) {
            $discussion = $this->updateDiscussionService($request);
        }

        $payment = [];
        if ($request->payment_details) {
            $payment = $this->updatePaymentDetails($request);
        }


        $basic_profile = new stdClass();
        if ($request->basic_profile) {
            $userC = new UserController();
            $basic_profile =  $userC->update_profile_settings($request);
        }

        $terms_condition = [];
        if ($request->terms_condition && $request->terms_condition['accepted'] == 1) {
            $terms_condition = ['accepted' => 1];

            // enable service 7
            $this->enableServices(['service' => 7]);
        } else if ($request->terms_condition && $request->terms_condition['accepted'] == 0) {
            $terms_condition = ['accepted' => 0, 'enable' => 0];

            // disable service 7
            $this->disableServices(['service' => 7]);
        }

        $points = $this->percentage_calculator();
        // dd($points);
       
        

        if (isset($user->profile_picture) && $user->profile_picture != null) {
            //if $basic_profile is not an object

            if (!is_object($basic_profile)) {
                $basic_profile = new stdClass();
            }


            $basic_profile->profile_picture = url('storage/profile_image/' . $user->profile_picture);
        }

        $res = $this->getAllServices($request);

        // get data from Illuminate\Http\JsonResponse object
        $res = $res->getData();

        //check & update T&C status if any of this is not 100
        $terms_condition_points = 0;
        if($points['basic_profile'] == 100){
            $terms_condition_points += 1;
        }
        if($points['chat'] == 100 || $res->appointment->enable == 1){
            $terms_condition_points += 1;
        }
        if($points['payment'] == 100){
            $terms_condition_points += 1;
        }

        // dd($terms_condition_points);
        if($terms_condition_points != 3){
            // disable service 7
            $this->disableServices(['service' => 7]);
            $points = $this->percentage_calculator();
        }

        //  dd($res);
        //  return $res;
        return response()->json([
            'calendar_service' => isset($calendarService['status']) && $calendarService['status'] == "error" ? $calendarService : $res->calendar_service,
            'prefilled_questions' => ['questions' => $prefilledQuestions],
            'chat' => isset($chatService['status']) && $chatService['status'] == "error" ? $chatService : $res->chat,
            'appointment' => isset($appointment['status']) && $appointment['status'] == "error" ? $appointment : $res->appointment,
            'discussion' => isset($discussion['status']) && $discussion['status'] == "error" ?  $discussion : $res->discussion,
            'payment_details' => $payment, // isset($payment['error']) ? $payment : $res->payment,
            'basic_profile' => $basic_profile,
            'terms_condition' => $terms_condition,
            'points' => $res->points
        ]);
    }


    public function getAllServices(Request $request, $id = null)
    {
        $user = auth()->user();
        if ($id !== null) {

            $user = \App\Models\User::find($id);
        }

        $csC = new CalenderServiceController();

        $calendarService = $csC->index($user->id);
        $prefilledQuestions = new stdClass();
        $prefilledQuestions->questions = \App\Models\PrefilledQuestions::where('user_id', $user->id)->get();
        $chatService = ChatService::where('user_id', $user->id)->first();
        $appointment = EnabledService::where('user_id', $user->id)->where('service_id', 1)->first();
        $appointmentService = new stdClass();
        $discussion = DiscussionService::where('user_id', $user->id)->first();

        if ($discussion == null) {
            $discussion = (object) array('enable' => 0);
        }
        $discussion->service_id = 3;
        $discussion->status = "success";
        $discussion->message = "";


        $payment = PaymentDetails::where('user_id', $user->id)->first();
        $basic_profile = \App\Models\User::where('id', $user->id)->first();
        $basic_profile['profile'] = \App\Models\UserProfile::where('user_id', $user->id)
                               ->join('cities','user_profile.city','=','cities.id')
                               ->join('states','user_profile.state','=','states.id')
                               ->select('user_profile.*','cities.name as city_name','states.name as state_name')
                               ->first();
        // $basic_profile['profile']['languages'] = NULL;
        $languages = \App\Models\UserLanguage::where('user_id', $user->id)
            ->join('languages', 'languages.id', '=', 'user_languages.language_id')
            ->select('languages.language', 'languages.id')
            ->get();

        if ($languages && $basic_profile['profile']) {
            $basic_profile['profile']['languages'] = $languages;
        }

        // language names in array
        $languageNames = [];
        foreach ($languages as $language) {
            //array_push($basic_profile['profile']['languages'], $language->language);
            $languageNames[] = $language->language;
        }
        if ($basic_profile['profile']) {
            $basic_profile['profile']['language_names'] = $languageNames;
        }

        $terms_condition = (object) ['accepted' => 0, 'enable'=>0, 'service_id' => 7, 'status' => 'error', 'message' => 'Terms and conditions not accepted'];

        if ($basic_profile->profile_picture != null) {
            $basic_profile->profile_picture = url('storage/profile_image/' . $basic_profile->profile_picture);
        }


        // get enabled services
        $enabledServices = EnabledService::where('user_id', $user->id)->get();
        foreach ($enabledServices as $service) {
            if ($service->service_id == 2) {
                if ($prefilledQuestions == null) {

                    $prefilledQuestions->questions = new \App\Models\PrefilledQuestions();
                    //  $prefilledQuestions->questions = [];

                }

                $prefilledQuestions->status = "success";
                $prefilledQuestions->message = "";
                if (count($prefilledQuestions->questions) == 0) {

                    $prefilledQuestions->status = "error";
                    $prefilledQuestions->message = "Prefilled questions not added";
                    $prefilledQuestions->enable = 0;
                }


                $prefilledQuestions->enable = $service->status;
                $prefilledQuestions->service_id = $service->service_id;
            }
            if ($service->service_id == 3) {
                if ($discussion == null) {
                    $discussion = (object) array('enable' => 0);
                    $discussion->status = "error";
                    $discussion->message = "Discussion service not added";
                } else {
                    $discussion->status = "success";
                    $discussion->message = "";
                }

                $discussion->enable = $service->status;
                $discussion->service_id = $service->service_id;
            }
            if ($service->service_id == 4) {
                if ($chatService == null) {
                    $chatService = (object) array('enable' => 0);
                    $chatService->status = "error";
                    $chatService->message = "Chat service not enabled";
                } else {
                    $chatService->status = "success";
                    $chatService->message = "";
                }
                $chatService->enable = $service->status;
                $chatService->service_id = $service->service_id;
            }
            if ($service->service_id == 5) {
                if ($appointment == null) {
                    $appointmentService = (object) array('enable' => 0);
                    $appointmentService->status = "error";
                    $appointmentService->message = "Appointment service not enabled";
                } else {
                    $appointmentService->status = "success";
                    $appointmentService->message = "";
                }

                $appointmentService->enable = $service->status;
                $appointmentService->service_id = $service->service_id;
            }
            if ($service->service_id == 1) {
                if ($calendarService == null) {
                    $calendarService = (object) array('enable' => 0);
                    $calendarService->status = "error";
                    $calendarService->message = "Calendar service not enabled";
                } else {
                    $calendarService->status = "success";
                    $calendarService->message = "";
                }

                $calendarService->enable = $service->status;
                $calendarService->service_id = $service->service_id;
            }

            if ($service->service_id == 6) {
                if ($payment == null) {
                    $payment = (object) array('enable' => 0);
                    $payment->status = "error";
                    $payment->message = "Payment not enabled";
                } else {
                    $payment->status = "success";
                    $payment->message = "";
                }
                $payment->enable = $service->status;
                $payment->service_id = $service->service_id;
            }

            if ($service->service_id == 7) {
                // if ($terms_condition == null) {
                //     $terms_condition = (object) array('enable' => 0);
                // }
                $terms_condition->enable = $service->status;
                $terms_condition->service_id = $service->service_id;
                $terms_condition->status = "success";
                $terms_condition->message = "";
            }
        }

        // if $calendarService is empty
        if ($calendarService == null) {
            $calendarService = (object) array('enable' => 0, 'status' => 'error', 'message' => 'Calendar service is not enabled');
        } else {
            $calendarService->status = 'success';
            $calendarService->message = "";
        }

        if (!isset($prefilledQuestions->enable)) {
            $prefilledQuestions = (object) array('enable' => 0, 'status' => 'error', 'message' => 'Prefilled questions service is not enabled');
        }
        if ($chatService == null) {
            $chatService = (object) array('enable' => 0, 'status' => 'error', 'message' => 'Chat service is not enabled');
        }
        if (!isset($appointmentService->enable)) {
            $appointmentService = (object) array('enable' => 0, 'status' => 'error', 'message' => 'Appointment service is not enabled');
        }

        if ($payment == null) {
            $payment = (object) array('enable' => 0, 'status' => 'error', 'message' => 'Payment service is not enabled');
        }



        return response()->json([
            'calendar_service' => $calendarService,
            'prefilled_questions' => $prefilledQuestions,
            'chat' => $chatService,
            'appointment' => $appointmentService,
            'discussion' => $discussion,
            'payment_details' => $payment,
            'basic_profile' => $basic_profile,
            'terms_condition' => $terms_condition,
            'points' => $this->percentage_calculator()
        ]);
    }

    public function enableServices($data)
    {
        $user = auth()->user();

        $service = $data['service'];

        $enabledService = EnabledService::where('user_id', $user->id)->where('service_id', $service)->first();
        if (!$enabledService) {
            $enabledService = new EnabledService();
            $enabledService->user_id = $user->id;
            $enabledService->service_id = $service;
            $enabledService->status = 1;
            $enabledService->save();
        } else {
            $enabledService->status = 1;
            $enabledService->save();
        }
        return 1;
    }

    public function disableServices($data)
    {
        $user = auth()->user();

        $service = $data['service'];

        $enabledService = EnabledService::where('user_id', $user->id)->where('service_id', $service)->first();
        if ($enabledService) {
            $enabledService->status = 0;
            $enabledService->save();
        }
        return 1;
    }

    public function getPrefilledQuestions(Request $request)
    {
        $user = auth()->user();

        $questions = \App\Models\PrefilledQuestions::where('user_id', $user->id)->get();

        return response()->json([
            'questions' => $questions
        ]);
    }

    public function addPrefilledQuestions(Request $request)
    {
        $user = auth()->user();
        $prefilReq = (object)$request->prefilled_questions;
        $questions = $prefilReq->questions ?? null;

        $enabled = 0;
        if ($prefilReq->enable == 0) {
            $status = $this->disableServices(['service' => 2]);
            $enabled = 0;
        } else {
            $status = $this->enableServices(['service' => 2]);
            $enabled = 1;
        }


        // check questions is not null and array
        if ($questions == null || !is_array($questions)) {
            if ($enabled == 1) {
                return [
                    'status' => 'error',
                    'message' => 'Please add at least one question',
                    'enabled' => $enabled
                ];
            } else {
                return [
                    'status' => 'success',
                    'message' => 'Prefilled questions disabled',
                    'enabled' => $enabled
                ];
            }
        }
        // remove all questions
        PrefilledQuestions::where('user_id', $user->id)->delete();

        foreach ($questions as $question) {
            $prefilledQuestion = new PrefilledQuestions();
            if (isset($question['id'])) {

                // check if question is already exists
                $existingQuestion = PrefilledQuestions::where('id', $question['id'])
                    ->where('user_id', $user->id)
                    ->first();
                if ($existingQuestion) {
                    $prefilledQuestion->id = $question['id'];
                } else {
                    return [
                        'message' => 'Question not found!',
                        'status' => 'error',
                        'enabled' => $enabled
                    ];
                }
            }
            $prefilledQuestion->question = $question['question'];
            $prefilledQuestion->user_id = $user->id;
            $prefilledQuestion->status = 1;
            $prefilledQuestion->save();
        };


        // enable prefilled questions service
        // merge service=2 to request
        // $prefilReq->merge(['service' => 2]);

        // if ($prefilReq->enable == 0) {
        //     $status = $this->disableServices(['service' => 2]);
        // } else {
        //     $status = $this->enableServices(['service' => 2]);
        // }

        $questions = \App\Models\PrefilledQuestions::where('user_id', $user->id)->get();
        return  $questions;
    }

    public function updatePrefilledQuestion(Request $request)
    {
        $user = auth()->user();

        $question = $request->question;
        $id = $request->id;

        $question = \App\Models\PrefilledQuestions::where('id', $id)->first();
        if ($question == null) {
            return response()->json([
                'message' => 'Question not found',
                'status' => 'error'
            ], 404);
        }

        $question->question = $request->question;
        $question->save();

        return response()->json([
            'message' => 'Question updated successfully',
            'status' => 'success'
        ]);
    }


    public function updateChatService(Request $request)
    {
        $user = auth()->user();

        $charReq = (object)$request->chat;

        $chatservice = ChatService::where('user_id', $user->id)->first();
        if (!$chatservice) {
            $chatservice = new ChatService();
            $chatservice->user_id = $user->id;
        }
        $chatservice->welcome_message = $charReq->welcome_message;
        $chatservice->save();


        //chat service = 4

        // merge service=4 to request
        // $request->merge();

        if (isset($charReq->enable) && $charReq->enable == 0) {
            $status = $this->disableServices(['service' => 4]);
        } else {
            $status = $this->enableServices(['service' => 4]);
        }

        $chatservice->status = $status;

        // $status = $this->enableServices(['service' => 4]);

        return $chatservice;
    }

    public function getChatService(Request $request)
    {
        $user = auth()->user();

        $chatservice = ChatService::where('user_id', $user->id)->first();

        return response()->json([
            'chatservice' => $chatservice
        ]);
    }


    public function getPaymentDetails(Request $request)
    {
        $user = auth()->user();

        $paymentDetails = \App\Models\PaymentDetails::where('user_id', $user->id)->first();

        return response()->json([
            'paymentDetails' => $paymentDetails
        ]);
    }

    public function updatePaymentDetails(Request $request)
    {
        $user = auth()->user();
        $paymentReq = (object)$request->payment_details;



        //payment service = 6
        //enable payment service
        $enable = 0;
        if (!isset($paymentReq->enable) || $paymentReq->enable == 0) {
            $status = $this->disableServices(['service' => 6]);
            $enable = 0;
        } else {
            $status = $this->enableServices(['service' => 6]);
            $enable = 1;
        }
        // if ($enable == 1) {
        $paymentDetails = \App\Models\PaymentDetails::where('user_id', $user->id)->first();
        if (!$paymentDetails) {
            $paymentDetails = new \App\Models\PaymentDetails();
            $paymentDetails->user_id = $user->id;
        }
        $paymentDetails->account_name = $paymentReq->account_name ?? "";
        $paymentDetails->account_number = $paymentReq->account_number ?? "";
        $paymentDetails->bank_name = $paymentReq->bank_name ?? "";
        $paymentDetails->ifsc_code = $paymentReq->ifsc_code ?? "";
        $paymentDetails->branch_name = $paymentReq->branch_name ?? "";
        $paymentDetails->upi_id = $paymentReq->upi_id ?? "";
        $paymentDetails->mobile_number = $paymentReq->mobile_number ?? "";
        $paymentDetails->save();
        // } else {
        //  $paymentDetails = new stdClass();
        // }


        $paymentDetails->enable = $enable;

        return $paymentDetails;
    }

    // enable appointment API
    public function enableAppointment(Request $request)
    {
        $user = auth()->user();

        $enable = $request->appointment['enable'];

        // check calendar service is enabled or not
        $calendarService = CalenderService::where('user_id', $user->id)->first();
        if (!$calendarService) {
            return [
                'error' => 'Please enable calendar service first',
                'status' => 'error'
            ];
        }

        // appointment service = 5

        // merge service=5 to request
        //  $request->merge();

        if ($enable == 1) {

            $status = $this->enableServices(['service' => 5]);

            if ($status == 1) {
                return [
                    'message' => 'Appointment enabled successfully',
                    'status' => 'success'
                ];
            } else {
                return [
                    'message' => 'Something went wrong',
                    'status' => 'error'
                ];
            }
        } else {
            $status = $this->disableServices(['service' => 5]);

            if ($status == 1) {
                return [
                    'message' => 'Appointment disabled successfully',
                    'status' => 'success'
                ];
            } else {
                return [
                    'message' => 'Something went wrong',
                    'status' => 'error'
                ];
            }
        }
    }

    // disable appointment API
    public function disableAppointment(Request $request)
    {
        $user = auth()->user();

        // appointment service = 5

        // merge service=5 to request
        // $request->merge(['service' => 5]);
        $status = $this->disableServices(['service' => 5]);

        if ($status == 1) {
            return response()->json([
                'message' => 'Appointment disabled successfully',
                'status' => 'success'
            ]);
        } else {
            return response()->json([
                'message' => 'Something went wrong',
                'status' => 'error'
            ], 400);
        }
    }


    // disable chat service API
    public function disableChatService(Request $request)
    {
        $user = auth()->user();

        // chat service = 4
        // merge service=4 to request
        $request->merge(['service' => 4]);
        $status = $this->disableServices($request);

        if ($status == 1) {
            return response()->json([
                'message' => 'Chat service disabled successfully',
                'status' => 'success'
            ]);
        } else {
            return response()->json([
                'message' => 'Something went wrong',
                'status' => 'error'
            ], 400);
        }
    }

    public function getDiscussionService(Request $request)
    {
        $user = auth()->user();

        $discussionService = DiscussionService::where('user_id', $user->id)->first();

        return response()->json([
            'discussionService' => $discussionService
        ]);
    }
    function isOverlaping($timeArray)
    {
        $isOverlaping = false;
        $count = count($timeArray);
        for ($i = 0; $i < $count; $i++) {
            for ($j = $i + 1; $j < $count; $j++) {
                if ($timeArray[$i]['start_time'] < $timeArray[$j]['end_time'] && $timeArray[$i]['end_time'] > $timeArray[$j]['start_time']) {
                    $isOverlaping = true;
                    break;
                }
            }
        }
        return $isOverlaping;
    }


    public function updateDiscussionService(Request $request)
    {
        $user = auth()->user();
        $discussionreq = (object)$request->discussion;


        //get calendar service & schedules
        $calendarService = CalenderService::where('user_id', $user->id)->first();

        if ($calendarService != null) {

            if ($calendarService->type == 1) {
                $schedules = ServiceSchedule::where('user_id', $user->id)->get();

                $dateTimeArray = [];
                //loop data and group by day
                foreach ($schedules as $schedule) {
                    $days = json_decode($schedule->days);
                    foreach ($days as $day) {
                        $timeArray = ['start_time' => strtotime(date('Y-m-d') . " " . $schedule->schedule_start_time), 'end_time' => strtotime(date('Y-m-d') . " " . $schedule->schedule_end_time)];
                        $dateTimeArray[$day][] = $timeArray;
                    }
                }
            } else {
                // $schedule = \App\Models\OpenCalendarSchedule::where('user_id', $user->id)->first();
                $openCalendar  = \App\Models\OpenCalendar::where('user_id', $user->id)->first();
                $days = json_decode($openCalendar->days);

                foreach ($days as $day) {
                    $timeArray = ['start_time' => strtotime(date('Y-m-d') . " " . $openCalendar->start_time), 'end_time' => strtotime(date('Y-m-d') . " " . $openCalendar->end_time)];
                    $dateTimeArray[$day][] = $timeArray;
                }
            }
        } else {
            $dateTimeArray = [];
        }

        foreach ($discussionreq->days as $day) {
            $timeArray = ['start_time' => strtotime(date('Y-m-d') . " " . $discussionreq->start_time), 'end_time' => strtotime(date('Y-m-d') . " " . $discussionreq->end_time)];
            $dateTimeArray[$day][] = $timeArray;
        }
        $resp = [];

        foreach ($dateTimeArray as $day => $timeArray) {
            $isOverlaping = $this->isOverlaping($timeArray);
            $resp[] = ['day' => $day, 'isOverlapping' => $isOverlaping ? 1 : 0];
        }

        $isOverlapping = max(array_column($resp, 'isOverlapping'));
        if ($isOverlapping == 1) {
            return ['message' => 'Time is overlapping with Calendar service.', 'status' => 'error'];
        }

        // End time overlapping validation

        $discussionService = DiscussionService::where('user_id', $user->id)->first();
        if (!$discussionService) {
            $discussionService = new DiscussionService();
            $discussionService->user_id = $user->id;
        }
        $discussionService->start_time = date('H:i:s', strtotime($discussionreq->start_time));
        $discussionService->end_time = date('H:i:s', strtotime($discussionreq->end_time));
        $discussionService->time_per_session = $discussionreq->time_per_session;
        $discussionService->prepaid_hours = $discussionreq->prepaid_hours;
        $discussionService->total_amount = $discussionreq->total_amount;
        $discussionService->days = $discussionreq->days ? json_encode($discussionreq->days) : "[]";
        $discussionService->save();

        // discussion service = 3

        // merge service=3 to request
        //   $discussionreq->merge(['service' => 3]);
        if (isset($discussionreq->enable) && $discussionreq->enable == 1) {
            $status = $this->enableServices(['service' => 3]);
        } else {
            $status = $this->disableServices(['service' => 3]);
        }

        if ($status == 1) {
            return $discussionService;
        } else {
            return [
                'message' => 'Something went wrong',
                'status' => 'error'
            ];
        }
    }

    // disable discussion service API
    public function disableDiscussionService(Request $request)
    {
        $user = auth()->user();

        // discussion service = 3
        // merge service=3 to request
        $request->merge(['service' => 3]);
        $status = $this->disableServices($request);

        if ($status == 1) {
            return response()->json([
                'message' => 'Discussion service disabled successfully',
                'status' => 'success'
            ]);
        } else {
            return response()->json([
                'message' => 'Something went wrong',
                'status' => 'error'
            ], 400);
        }
    }

    public function enableAnyServices(Request $request)
    {
        $user = auth()->user();


        $service = \App\Models\Service::where('id', $request->service)->first();
        if (!$service) {
            return response()->json([
                'message' => 'Service not found',
                'status' => 'error'
            ], 400);
        }


        $status = $this->enableServices($request);




        if ($status == 1) {
            return response()->json([
                'message' => $service->service_name . ' service enabled successfully',
                'status' => 'success'
            ]);
        } else {
            return response()->json([
                'message' => 'Something went wrong',
                'status' => 'error'
            ], 400);
        }
    }

    public function getServices(Request $request)
    {
        $user = auth()->user();
        $services = \App\Models\Service::query()->get();
        return response()->json([
            'services' => $services
        ]);
    }


    public function percentage_calculator()
    {
        // basic profile percentage

        $user = auth()->user();
        $profile = $user->profile;
        $enabledServices = \App\Models\EnabledService::where('user_id', $user->id)->get();
        $servicesStatus = [];
        foreach ($enabledServices as $k => $v) {
            $servicesStatus[$v->service_id] = $v->status;
        }

        // dd($servicesStatus);

        $points['basic_profile'] = 0;
        $points['calendar'] = 0;


        if (isset($user->profile_picture) && $user->profile_picture != null) {
            $points['basic_profile'] += 20;
        }

        if (isset($user->name) && $user->name != "") {
            $points['basic_profile'] += 20;
        }

        if (isset($profile->service_category) && $profile->service_category != "") {
            $points['basic_profile'] += 20;
        }

        if (isset($profile->service_offered) && $profile->service_offered != "") {
            $points['basic_profile'] += 20;
        }

        // get skill_set
        if (isset($profile->skill_set) && $profile->skill_set != "") {
            //$points['basic_profile'] += 20;
            // if (!is_array($profile->skill_set)) {
            //     $skill_set = json_decode($profile->skill_set);
            // } else {
            //     $skill_set = $profile->skill_set;
            // }
            $skill_set = $profile->skill_set;

            // get length of skill_set

            $length = strlen($skill_set);
            if ($length >= 10) {
                $points['basic_profile'] += 20;
            }
        }

        // add 10 points if expertise is less than 30 characters

        //Title - 5 Points
        // Calendar - If Service Taker Provides 6 days of Calendar Service - 20 Points
        // Time Per Session - 10 Points   		Paid By - 10 Points
        // Gap btw Session - 10 Points		Charged by - 10 Points
        // No Of Session - 10 Points			Allow Booking For Day - 5 Points
        // Start Time & End Time - 10 Points
        // Charges/ Session - 10 Points 

        // check if calendar is enabled
        $calendar = CalenderService::where('user_id', $user->id)->first();
        // calendat type



        $calendar_type = $calendar->type ?? 0;
        if ($calendar_type == 1) {
            $daysCount = 0;
            $pointArray = [100];
            $index = 0;
            $calculatedPoints = 0;
            foreach ($calendar->service_schedule as $schedule) {
                // $days = $schedule->days;
                // if (!is_array($days)) {
                //     $days = json_decode($days);
                // }
                //if (is_array($days)) {
                // $daysCount += count($days);
                $calculatedPoints = isset($pointArray[$index]) ? $pointArray[$index] : 100;
                // }
                $index++;
            }

            //  $daysPoints = round((50 / 6) * $daysCount, 2);

            $points['calendar'] = $calculatedPoints;
        } else if ($calendar_type == 2) {
            $calendar->open_calendar = \App\Models\OpenCalendar::where('user_id', $user->id)->get();
            $points['calendar'] = 0;
            $daysCount = 0;
            // foreach ($calendar->open_calendar as $k => $v) {
            //     $daysCount += count(json_decode($v->days));
            // }
            // if ($daysCount == 6) {
            //     $daysPoints = 20;
            // }
            if (count($calendar->open_calendar) > 0) {
                $points['calendar'] = 100;
            }
            //$daysPoints;
            // $daysPoints = round((50 / 6) * $daysCount, 2);
            //   $points['calendar'] += $daysPoints;
        } else {
            $points['calendar'] = 0;
        }

        //  if ($points['calendar'] != 0) {
        //$points['calendar'] round up to next 5th multiplication
        // $points['calendar'] = round($points['calendar'] / 5) * 5;
        //  }



        // prefilled questions
        $prefilledQuestions = \App\Models\PrefilledQuestions::where('user_id', $user->id)->get();
        
        //check prefilled question service is enable run switch else set point as 0
        if(isset($servicesStatus[2]) && $servicesStatus[2] == 1){
            switch (count($prefilledQuestions)) {
                case 0:
                    $points['prefilled_questions'] = 0;
                    break;
                case 1:
                    $points['prefilled_questions'] = 100;
                    break;
                default:
                    $points['prefilled_questions'] = 100;
                    break;
            }
        }else{
            $points['prefilled_questions'] = 0;
        }

        // check discussion service
        $discussionService = \App\Models\DiscussionService::where('user_id', $user->id)->first();
        if ($discussionService) {
            $points['discussion'] = 0;
            if ($discussionService->start_time != null && $discussionService->end_time != null) {
                $points['discussion'] += 20;
            }

            if ($discussionService->time_per_session != 0) {
                $points['discussion'] += 20;
            }

            // prepaid_hours
            if ($discussionService->prepaid_hours != 0) {
                $points['discussion'] += 20;
            }

            //total_amount
            if ($discussionService->total_amount != 0) {
                $points['discussion'] += 20;
            }

            //  $points['discussion'] = 80;
        } else {
            $points['discussion'] = 0;
        }

        if (isset($servicesStatus[3]) && $servicesStatus[3] == 1) {
            $points['discussion'] += 20;
        }
        if (!isset($servicesStatus[3]) || $servicesStatus[3] == 0) {
            $points['discussion'] = 0;
        }


        // 
        if (isset($servicesStatus[5]) && $servicesStatus[5] == 1) {
            $points['appointment'] = 100;
        } else {
            $points['appointment'] = 0;
        }


        // get chat service
        $chatService = \App\Models\ChatService::where('user_id', $user->id)->first();
        if ($chatService) {

            // length of welcome_message > 30 characters 50 points else 30 points
            if (strlen($chatService->welcome_message) > 10) {
                $points['chat'] = 50;
            } else {
                $points['chat'] = 30;
            }
        } else {
            $points['chat'] = 0;
        }


        if (isset($servicesStatus[4]) && $servicesStatus[4] == 1) {
            $points['chat'] += 50;
        }


        // get payment details
        $paymentDetails = \App\Models\PaymentDetails::where('user_id', $user->id)->first();
        $points['payment'] = 0;
        if ($paymentDetails) {
            if ($paymentDetails->account_name) {
                $points['payment'] += 20;
            }
            if ($paymentDetails->account_number) {
                $points['payment'] += 20;
            }
            if ($paymentDetails->ifsc_code) {
                $points['payment'] += 20;
            }
            if ($paymentDetails->upi_id) {
                $points['payment'] += 20;
            }
            if ($paymentDetails->mobile_number) {
                $points['payment'] += 20;
            }
        } else {
            $points['payment'] = 0;
        }


        // get service 7

        if (isset($servicesStatus[7]) && $servicesStatus[7] == 1) {
            $points['terms_condition'] = 100;
        } else {
            $points['terms_condition'] = 0;
        }
        //dd($servicesStatus);
        return $points;
    }

    public function delete_service(Request $request)
    {
        $user = auth()->user();
        $serviceid = $request->service_id;

        $service = EnabledService::where('service_id', $serviceid)->where('user_id', $user->id)->first();
     

        switch ($serviceid) {
            case 1:
                // calendar service
                $calendar = CalenderService::where('user_id', $user->id)->first();
            
                // get all schedules
                $schedules = \App\Models\ServiceSchedule::where('user_id', $user->id)->get();
                if ($schedules) {
                    foreach ($schedules as $schedule) {
                        $schedule->delete();
                    }
                }
                // get all open calendar
                $openCalendar = \App\Models\OpenCalendar::where('user_id', $user->id)->get();
                if ($openCalendar) {
                    foreach ($openCalendar as $calendar) {
                        $calendar->delete();
                    }
                }
               CalenderService::where('user_id', $user->id)->delete();
                
                if ($calendar) {
                    $calendar->delete();
                }
                break;
            case 2:
                // prefilled questions
                $prefilledQuestions = \App\Models\PrefilledQuestions::where('user_id', $user->id)->get();
                if ($prefilledQuestions) {
                    foreach ($prefilledQuestions as $question) {
                        $question->delete();
                    }
                }
                break;
            case 3:
                // discussion service
                $discussionService = \App\Models\DiscussionService::where('user_id', $user->id)->first();
                if ($discussionService) {
                    $discussionService->delete();
                }
                break;
            case 4:
                // chat service
                $chatService = \App\Models\ChatService::where('user_id', $user->id)->first();
                if ($chatService) {
                    $chatService->delete();
                }
                break;
            case 5:
                // appointment service
                //delete from enabled service
                break;
            case 6:
                // payment service
                $paymentDetails = \App\Models\PaymentDetails::where('user_id', $user->id)->first();
                if ($paymentDetails) {
                    $paymentDetails->delete();
                }
                break;
        }
        $this->disableServices(['service' => $serviceid]);


        if ($service) {
            $service->delete();
            return response()->json(['status' => 'success', 'message' => 'Service deleted successfully']);
        } else {
            return response()->json(['status' => 'error', 'message' => 'Service not found']);
        }
    }
}
