<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OTP extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public $details;
    public function __construct($otp)
    {
        //
        $this->details = [
            'title' => 'OTP',
            'otp' =>  $otp
        ];
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('email.otp')
            ->with($this->details)
            // ->from('hello@q-software.com', 'Q Software')
            ->subject('Hello & Welcome!');
        //   ->replyTo('hello@q-software.com', 'Q Software');
    }
}
