<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CalenderService extends Model
{
    use HasFactory;
    protected $table = 'calendar_services';

    //  has many service_schedule
    public function service_schedule()
    {
        return $this->hasMany('App\Models\ServiceSchedule', 'calendar_service_id', 'id');
    }

    // has one open_calendar 
    public function open_calendar()
    {
        return $this->hasOne('App\Models\OpenCalendar', 'calendar_service_id', 'id');
    }
}
