<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ServiceBooking extends Model
{
    use HasFactory;
    // has one service
    public function service()
    {
        return $this->hasOne(Service::class, 'id', 'service_id');
    }
    // has One user
    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }

    // has One provider
    public function provider()
    {
        return $this->hasOne(User::class, 'id', 'provider_id');
    }

    // get total booked duration
    public function getTotalDurationAttribute()
    {

        // get sum of duration
        $totalDuration = $this->where('provider_id', $this->provider_id)
            ->where('booking_date', $this->booking_date)
            ->where('status', 1)
            ->sum('duration');

        return $totalDuration;
    }

    // get total clients 
    public function getTotalClientsAttribute()
    {
        // get count of distinct clients
        $totalClients = $this->where('provider_id', $this->provider_id)
            ->where('status', 1)
            ->distinct('user_id')
            ->count('user_id');

        return $totalClients;
    }
}
