<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ServiceSchedule extends Model
{
    use HasFactory;


    // has many schedule_worktime
    public function schedule_worktime()
    {
        return $this->hasMany('App\Models\ScheduleWorktime', 'schedule_id', 'id');
    }

    // has many work_slots
    public function work_slots()
    {
        return $this->hasMany('App\Models\WorkSlot', 'schedule_id', 'id');
    }

    // belongs to calendar_service
    public function calendar_service()
    {
        return $this->belongsTo('App\Models\CalenderService', 'calendar_service_id', 'id');
    }
}
