<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserLanguage extends Model
{
    use HasFactory;
    protected $table = 'user_languages';
    // fillabel
    protected $fillable = [
        'user_id',
        'language_id'
    ];

    // belongs to user
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    // belongs to language
    public function language()
    {
        return $this->belongsTo(Language::class, 'language_id');
    }
}
