<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WorkSlot extends Model
{
    use HasFactory;
    protected $table = 'work_slots';
    // fillable
    protected $fillable = [
        'schedule_id',
        'worktime_id',
        'user_id',
        'title',
        'start_time',
        'end_time'
    ];

    // belongs to service_schedule
    public function service_schedule()
    {
        return $this->belongsTo('App\Models\ServiceSchedule', 'schedule_id', 'id');
    }

    // belongs to schedule_worktime
    public function schedule_worktime()
    {
        return $this->belongsTo('App\Models\ScheduleWorktime', 'worktime_id', 'id');
    }
}
