<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterUserAddUsername extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // add username column to users table
        Schema::table('users', function (Blueprint $table) {
            $table->string('username')->nullable()->after('name');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // drop username
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('username');
        });
    }
}
