<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCategoryProfileTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('user_profile', function (Blueprint $table) {
            $table->integer('service_category')->after('user_id')->default(0);
            // service_offered
            $table->string('service_offered')->after('service_category')->default('');
            // skill_set json
            $table->json('skill_set')->after('service_offered')->nullable()->default(null);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('user_profile', function (Blueprint $table) {
            $table->dropColumn('service_category');
            $table->dropColumn('service_offered');
            $table->dropColumn('skill_set');
        });
    }
}
