<?php

use App\Http\Controllers\API\PavsController;
use App\Http\Controllers\API\UserController;
use App\Http\Controllers\ChatController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// user registration API
Route::post('register', 'App\Http\Controllers\API\AuthController@register');
// user login API
Route::post('login', 'App\Http\Controllers\API\AuthController@login');
// // user logout API
// Route::post('logout', 'App\Http\Controllers\API\AuthController@logout');

//check_username
Route::post('check_username', 'App\Http\Controllers\API\AuthController@check_username');


//social_login
Route::post('social_login', 'App\Http\Controllers\API\AuthController@social_login');

// send otp
Route::post('request_otp', 'App\Http\Controllers\API\AuthController@get_otp');
// login_otp
Route::post('login_otp', 'App\Http\Controllers\API\AuthController@login_otp');


// verify otp
Route::post('verify_otp', 'App\Http\Controllers\API\AuthController@verify_otp');
Route::get('remove_data', 'App\Http\Controllers\API\UserController@remove_data');

//logout from all devices send_otp
Route::post('logout_all_send_otp', 'App\Http\Controllers\API\AuthController@logout_all_send_otp');
Route::post('logout_all_verity_otp', 'App\Http\Controllers\API\AuthController@logout_all_verity_otp');

Route::middleware('auth:api')->group(function () {
    // user logout API
    Route::post('logout', 'App\Http\Controllers\API\AuthController@logout');

    Route::get('user', 'App\Http\Controllers\API\AuthController@userInfo');
    Route::get('user/{id}', 'App\Http\Controllers\API\UserController@get_user');
    Route::post('update_settings', 'App\Http\Controllers\API\UserController@store_profile');

    // update_profile
    Route::post('update_profile', 'App\Http\Controllers\API\UserController@update_profile');

    // list states & cities
    Route::get('config/states', 'App\Http\Controllers\API\ConfigurationController@getStates');
    Route::get('config/cities/{state_id}', 'App\Http\Controllers\API\ConfigurationController@getCities');
    Route::get('config/languages', 'App\Http\Controllers\API\ConfigurationController@getLanguages');
    // list categories
    Route::get('config/categories', 'App\Http\Controllers\API\ConfigurationController@getCategories');
    // remove_data

    Route::get('settings', 'App\Http\Controllers\API\ServiceController@getAllServices');
    Route::post('settings', 'App\Http\Controllers\API\ServiceController@updateSettings');


    // accept_terms
    Route::post('accept_terms', 'App\Http\Controllers\API\UserController@accept_terms');
    //request terms
    Route::get('request_terms', 'App\Http\Controllers\API\UserController@request_terms');

    // calendar service
    Route::get('calendar_service', 'App\Http\Controllers\API\CalenderServiceController@index');
    Route::post('calendar_service', 'App\Http\Controllers\API\CalenderServiceController@store');
    // Route::post('calendar_service/update_service_schedules', 'App\Http\Controllers\API\CalenderServiceController@updateServiceSchedules');
    // updateWorkTime
    // Route::post('calendar_service/update_work_time', 'App\Http\Controllers\API\CalenderServiceController@updateWorkTime');
    // Route::post('calendar_service', 'App\Http\Controllers\API\CalenderServiceController@enableCalendarService');

    Route::post('calendar_service/schedule', 'App\Http\Controllers\API\CalenderServiceController@saveServiceSchedule');

    // deleteSchedule
    Route::post('calendar_service/delete_schedule/{id}', 'App\Http\Controllers\API\CalenderServiceController@deleteSchedule');


    // prefilled questions
    Route::get('prefilled_questions', 'App\Http\Controllers\API\ServiceController@getPrefilledQuestions');
    Route::post('prefilled_questions', 'App\Http\Controllers\API\ServiceController@addPrefilledQuestions');
    Route::post('prefilled_questions/update', 'App\Http\Controllers\API\ServiceController@updatePrefilledQuestion');

    //Chat services
    Route::get('chat_services', 'App\Http\Controllers\API\ServiceController@getChatService');
    Route::post('chat_services', 'App\Http\Controllers\API\ServiceController@updateChatService');

    // payment details
    Route::get('payment_details', 'App\Http\Controllers\API\ServiceController@getPaymentDetails');
    Route::post('payment_details', 'App\Http\Controllers\API\ServiceController@updatePaymentDetails');


    // enable appointment
    Route::post('appointment/enable', 'App\Http\Controllers\API\ServiceController@enableAppointment');
    Route::post('appointment/disable', 'App\Http\Controllers\API\ServiceController@disableAppointment');

    // disable chat service
    Route::post('chat_service/disable', 'App\Http\Controllers\API\ServiceController@disableChatService');


    // discussion services
    Route::get('discussion_services', 'App\Http\Controllers\API\ServiceController@getDiscussionService');
    Route::post('discussion_services', 'App\Http\Controllers\API\ServiceController@updateDiscussionService');

    // disable discussion service
    Route::post('discussion_service/disable', 'App\Http\Controllers\API\ServiceController@disableDiscussionService');

    //enableAnyServices
    Route::post('service/enable', 'App\Http\Controllers\API\ServiceController@enableAnyServices');
Route::post('service/delete', 'App\Http\Controllers\API\ServiceController@delete_service');

    // get service details
    Route::get('service_details', 'App\Http\Controllers\API\ServiceController@getServices');
    Route::post('service_providers', 'App\Http\Controllers\API\PavsController@serviceProviders');
    Route::get('categories', 'App\Http\Controllers\API\PavsController@categories');
    Route::get('service_providers/{id}', 'App\Http\Controllers\API\PavsController@serviceProvidersById');


    Route::get('prepaid_hours', 'App\Http\Controllers\API\PavsController@prepaidHours');

    //Route::get('perc', 'App\Http\Controllers\API\ServiceController@percentage_calculator');
    
    Route::get('getschedules/{id}/{day}/{scheduleid?}','App\Http\Controllers\API\PavsController@getschedules');
    Route::get('getSlots/{id}','App\Http\Controllers\API\PavsController@getSlots');
    Route::post('schedule/store_bookings','App\Http\Controllers\API\PavsController@store_userbookings');
    Route::get('/general_schedules/{id}/{month?}','App\Http\Controllers\API\PavsController@general_schedules');

    // get pre-filled questions by service provider
    Route::get('prefilled_questions/{id}', 'App\Http\Controllers\API\PavsController@get_prefilled_questions');
    Route::get('user_by_xmpp', 'App\Http\Controllers\API\UserController@get_user_by_xmpp');

    // save_answers
    Route::post('save_answers', 'App\Http\Controllers\API\PavsController@save_answers');

    Route::controller(PavsController::class)->group(function(){
         Route::post('/opencalschedules','opencalschedules');
         Route::post('/opencal/getminutes','opencal_getminutes');
         Route::post('checktime_is_available','checktime_is_available');
         Route::get('discussion_slots/{id}','discussion_slots');
         Route::post('discussion_slot_status','discussion_slot_status');
         Route::post('get_user_bookings','get_user_bookings');
         Route::post('my_session','my_session');
         Route::get('dicussion_details/{id}/{daystring}','dicussion_details');
         //Booking Cancel
         Route::post('cancel_booking/get_available_days','reschedule_available_days');
         Route::post('get_client_list','get_client_list');
         Route::get('global_search/{id}','global_search');
         Route::get('test/{id}','group_schedulecal_slots');
         //for booking cancel || refund
         Route::post('cancel_booking','cancel_booking');
         //individual cancel for provider
         Route::post('individual_cancel','individual_cancel');
         Route::get('taker/send_reschedule_request/{id}','send_reschedule_request');
         Route::post('provider/check_available_time','check_available_time');
         Route::post('provider/send_reschedule_request','provider_send_reschedule_request');
         Route::post('get_request_list','get_request_list');
         Route::get('accept_request/{id}','accept_request');

         //get schedule calendar booking list from current date to month end
         Route::get('schedulecal_booking_list/{id?}','schedulecal_booking_list');

         //get user profile details from xmppid
         Route::post('user_profile','user_profile');

         //provider session start status update
         Route::post('provider_session_status_update','provider_session_status_update');

         //media file transfer, upload files & return file path
         Route::post('upload_file','upload_file');

         //Schedule Calendar send Request
         Route::post('schedule_cal_send_request','schedule_cal_send_reschedule_request');
         Route::post('schedule_cal_accept_request/','schedule_cal_accept_request');

         //save ratings and feedbacks
         Route::post('save_ratings','store_rating_feedbacks');
         Route::post('fetch_all_ratings_feedbacks','fetch_all_ratings_feedbacks');

         //slot detailed view
         Route::post('slot_detailed_view','slot_detailed_view');
    });

    Route::controller(ChatController::class)->prefix('chat')->group(function(){
        Route::post('send_message','send_message');
        Route::get('conversation_list','conversation_list');
        Route::post('create_group','create_group');
        Route::post('update_as_read','update_as_read');
        Route::get('participants_list/{id}','participants_list');
        Route::post('add_participants','add_participants');
        Route::get('explore_conversations/{id}','explore_conversations');
    });

});

Route::controller(UserController::class)->group(function(){
    Route::post('check_version','check_version');
    Route::get('login_status/{id}','login_status');
    Route::get('request-for-mail-verification','request_for_mail_verification')->middleware('auth:api');
    Route::post('verify-mail-otp','verify_mail')->middleware('auth:api');
});
